import alice.tucson.api.*;
import alice.logictuple.*;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

/**
 * GUI per l'inserimento di messaggi e visualizzazione della chat
 *
 * @author  Rossella Rubino
 * @version agosto 2004
 *
 * use java ChatAgent <user name> <chat_room address> <user address>
 *
 */
public class ChatAgent extends JFrame {

    private TucsonContext context;    
    private TupleCentreId chatId,chatIdR,userTC;
    private String name,host;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTextArea output;
    private JPanel jPanel2;
    private JTextField input;
        
    public ChatAgent(String n,String h,TupleCentreId c,TupleCentreId cr) throws Exception {

		this.name=n;
		this.chatId=c;
		this.chatIdR=cr;
		this.host=h;
		
		userTC = new TupleCentreId(name.toLowerCase()+" @ '"+host+"'");
		AgentId aid=new AgentId("user('"+name+"')");
		context=Tucson.enterContext(new DefaultContextDescription(aid));
		
		System.out.println("Start...");
		
	    // l'utente chiede di entrare nella chat
	    LogicTuple lt=LogicTuple.parse("join(user("+name+"),host('"+host+"'))");
	    try{
	    	context.out(chatId,lt);
	    }
	    catch(UnreachableNodeException une){}
	    try{
	    	context.out(chatIdR,lt);
	    }
	    catch(UnreachableNodeException une){}
	    
	    
	    //verifica se gli  stato permesso
	    LogicTuple rt=LogicTuple.parse("accepted("+name+",_)");
	    System.out.println("Attendere...controllo nick");

	    LogicTuple res=context.in(userTC,rt);
	    	    
        if (res.getArg(1).toString().equals("false")){
            System.err.println(name+"  gi usato");
            System.exit(-1);
        }

		System.err.println(name+" entra in chat");
		
        initComponents ();
        pack ();
        setTitle("CHAT user: "+name+" at "+host);
        setSize(400,400);

        new AgentObserverMsg(output,aid,userTC).start();
        new AgentObserverJoin(output,aid,userTC).start();
        new AgentObserverLeave(output,aid,userTC).start();
    }

    /** metodo chiamato all'interno del costruttore per
     *  inizializzare la finestra 
     */
    private void initComponents() {
        jPanel1 = new JPanel();
        jScrollPane1 = new JScrollPane();
        output = new JTextArea();
        jPanel2 = new JPanel();
        input = new JTextField();

        getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints1;

        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent evt) {
                exitForm(evt);
            }
        });

        jPanel1.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2;

        jPanel1.setBorder(new javax.swing.border.TitledBorder("output"));
        output.setEditable(false);
        output.setFont(new Font("Verdana", 0, 12));
        jScrollPane1.setViewportView(output);

        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.fill = GridBagConstraints.BOTH;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        jPanel1.add(jScrollPane1, gridBagConstraints2);

        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.fill = GridBagConstraints.BOTH;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        getContentPane().add(jPanel1, gridBagConstraints1);

        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints3;

        jPanel2.setBorder(new javax.swing.border.TitledBorder("input"));
        jPanel2.setPreferredSize(new Dimension(55, 60));
        input.setFont(new Font("Verdana", 0, 12));
        input.setBorder(new javax.swing.border.LineBorder(Color.black));
        input.setPreferredSize(new Dimension(2, 22));
        input.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                inputActionPerformed(evt);
            }
        });

        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints3.weightx = 1.0;
        jPanel2.add(input, gridBagConstraints3);

        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.weightx = 1.0;
        getContentPane().add(jPanel2, gridBagConstraints1);

    }
    
	/** invio di messaggi
	 *@param evento associato all'invio dei messaggi
	 */
  	private void inputActionPerformed (ActionEvent evt) {
        try {	        
        
	        LogicTuple msg=LogicTuple.parse("msg(from('"+name+"'),host('"+host+"'),text('"+input.getText()+"'),ts('"+System.currentTimeMillis()+"'))");        		
	    
	        try{
	        	context.out(chatId,msg);      	     
	        }
	        catch(UnreachableNodeException une){}
	        
	        try{
	        	context.out(chatIdR,msg);      	     
	        }
	        catch(UnreachableNodeException une){}
	         
            input.setText("");
            
        } catch (Exception ex){
            ex.printStackTrace();
        }
  	}

    /** chiude l'applicazione 
     *@param evento associato alla chiusura dell'applicazione
     **/
    private void exitForm(WindowEvent evt) {
    	try{
        	try {
            	context.out(chatId,LogicTuple.parse("leave('"+name+"','"+host+"')"));
        	} 
        	catch(UnreachableNodeException une){}
        	try {
            	context.out(chatIdR,LogicTuple.parse("leave('"+name+"','"+host+"')"));
        	}	 
        	catch(UnreachableNodeException une){}
        
        	this.dispose();
        	System.exit(0);
        }
        catch(Exception e){
        	e.printStackTrace();
        }
    }

    public static void main(String args[]) throws Exception {
        if (args.length!=4 ){
            System.err.println("args:  <user name> <chat room address> <chat room address 2> <user address>");
            System.exit(-1);
        }
        TupleCentreId tc = new TupleCentreId("chat_room @ '"+args[1]+"'");
        TupleCentreId tc2 = new TupleCentreId("chat_room @ '"+args[2]+"'");

        new ChatAgent(args[0],args[3],tc,tc2).show();

    }    
}